import { showMessage } from './messages.js';
import { getOpenTabs } from './utils.js';

export function initializeApiCalls() {
  // دکمه‌های جابجایی
  document.querySelectorAll('.move-up, .move-down').forEach(btn => {
    btn.addEventListener('click', function(e) {
      e.stopPropagation();
      e.preventDefault();

      const catID = this.dataset.id;
      const direction = this.classList.contains('move-up') ? 'up' : 'down';

      // ذخیره وضعیت تب‌های باز قبل از reload
      const openTabs = getOpenTabs();
      localStorage.setItem('openCategories', JSON.stringify(openTabs));

      // ارسال درخواست به سرور
      fetch('move_category.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({ catID: catID, direction: direction })
      })
      .then(r => r.json())
      .then(data => {
        if (data.success) {
          location.reload();
        } else {
          showMessage('خطا: ' + (data.message || 'نامشخص'), 'error');
        }
      })
      .catch(err => {
        console.error(err);
        showMessage('خطا در ارتباط با سرور', 'error');
      });
    });
  });

  // مدیریت حذف دسته
  document.querySelectorAll('.confirm-delete').forEach(btn => {
    btn.addEventListener('click', function(e) {
      const catID = this.dataset.id;
      if (!catID) return;
      
      // ارسال درخواست حذف
      fetch('delete_category.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8' },
        body: new URLSearchParams({ catID: catID })
      })
      .then(r => r.json())
      .then(data => {
        if (data.success) {
          showMessage('حذف با موفقیت انجام شد', 'success');
          location.reload();
        } else {
          showMessage('خطا: ' + (data.message || 'نامشخص'), 'error');
        }
      })
      .catch(err => {
        console.error(err);
        showMessage('خطا در حذف', 'error');
      });
    });
  });
}