<?php
include 'php/config.php';

$languages = $pdo->query("SELECT * FROM languages")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO translations (language_id, `group`, `key`, `value`) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['language_id'], $_POST['group'], $_POST['key'], $_POST['value']]);
    header("Location: translations.php");
    exit;
}

$translations = $pdo->query("SELECT t.*, l.name as lang_name FROM translations t JOIN languages l ON l.id=t.language_id")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>مدیریت ترجمه‌ها</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
    <h2>📑 لیست ترجمه‌ها</h2>
    <table class="table table-bordered">
        <tr><th>زبان</th><th>گروه</th><th>کلید</th><th>مقدار</th></tr>
        <?php foreach ($translations as $tr): ?>
            <tr>
                <td><?= $tr['lang_name'] ?></td>
                <td><?= $tr['group'] ?></td>
                <td><?= $tr['key'] ?></td>
                <td><?= $tr['value'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3 class="mt-4">➕ افزودن ترجمه جدید</h3>
    <form method="POST">
        <select name="language_id" class="form-control mb-2">
            <?php foreach ($languages as $lang): ?>
                <option value="<?= $lang['id'] ?>"><?= $lang['name'] ?></option>
            <?php endforeach; ?>
        </select>
        <input name="group" class="form-control mb-2" placeholder="گروه (مثلا auth)">
        <input name="key" class="form-control mb-2" placeholder="کلید (مثلا login)">
        <input name="value" class="form-control mb-2" placeholder="مقدار (مثلا ورود)">
        <button class="btn btn-success">ذخیره</button>
    </form>
</body>
</html>
