<?php
// form/form_ad1d_level1.php
?>

<!-- ================= فرم افزودن سطح ۱ ================= -->
<form id="add_level1" class="add-form form-main1" dir="<?= $dir ?>">
    <?php if (!empty($languages)): ?>
        
        <!-- زبان پیش‌فرض -->
        <div class="base-add-level1">
            <?php foreach ($languages as $langRow): ?>
                <?php if ($langRow['code'] == $default_lang): ?>
                    <div class="form-group">
                        <input type="text" 
                               name="name_<?= htmlspecialchars($langRow['code']) ?>" 
                               placeholder="نام به <?= htmlspecialchars($langRow['name']) ?>">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

        <!-- دکمه نمایش زبان‌های بیشتر -->
        <button type="button" class="toggle-langs-btn">➕ افزودن زبان‌ها</button>

        <!-- بقیه زبان‌ها -->
        <div class="hidden-add-level1" style="display:none; margin-top:10px;">
            <?php foreach ($languages as $langRow): ?>
                <?php if ($langRow['code'] != $default_lang): ?>
                    <div class="form-group">
                        <input type="text" 
                               name="name_<?= htmlspecialchars($langRow['code']) ?>" 
                               placeholder="نام به <?= htmlspecialchars($langRow['name']) ?>">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

    <?php else: ?>
        <p>هیچ زبانی تعریف نشده است.</p>
    <?php endif; ?>

    <div class="form-actions">
        <button type="submit" class="btn-submit">ذخیره</button>
        <button type="button" class="btn-cancel">انصراف</button>
    </div>
</form>

<!-- اسکریپت باز/بستن -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleBtn = document.querySelector(".toggle-langs-btn");
    const hiddenDiv = document.querySelector(".hidden-add-level1");

    toggleBtn.addEventListener("click", function() {
        if (hiddenDiv.style.display === "none" || hiddenDiv.style.display === "") {
            hiddenDiv.style.display = "block";
            toggleBtn.textContent = "✖ بستن زبان‌ها";
        } else {
            hiddenDiv.style.display = "none";
            toggleBtn.textContent = "➕ افزودن زبان‌ها";
        }
    });
});
</script>
