<?php
require __DIR__ . '/config.php';
require __DIR__ . '/functions.php';

$L = load_lang();
$view = $_GET['view'] ?? 'register'; // register | login
$flashes = flash();
?>
<!doctype html>
<html lang="<?= get_lang() ?>" dir="<?= dir_attr() ?>">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= e($L['app_title']) ?></title>

<!-- فونت‌ها: Vazirmatn + IRANSansX (جایگزین آزاد برای ایران‌سنس) -->
<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.fontcdn.ir/Font/Persian/IRANSansX/IRANSansX.css">

<!-- آیکون‌ها -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer"/>

<!-- استایل کاربر (style.css) - در صورت وجود؛ سپس استایل سفا
رشیما -->
<link rel="stylesheet" href="assets/css/fonts.css">
<link rel="stylesheet" href="assets/css/animate.css">
<link rel="stylesheet" href="assets/css/rtl.css">
<link rel="stylesheet" href="assets/css/ltr.css">
<link rel="stylesheet" href="assets/css/responsive.css">
<link rel="stylesheet" href="assets/css/style.css">
<link rel="stylesheet" href="assets/css/main.css">



</head>
<body class="<?= align_class() ?>">
  <!-- پس‌زمینه متحرک -->
  <div class="bg-animated"></div>

  <div class="container glass fade-in">
       <div class="lang-title"> 
    <div class="lang-switch">
      <a href="?lang=fa&view=<?= e($view) ?>">🇮🇷 </a>
          <a href="?lang=en&view=<?= e($view) ?>">🇬🇧</a>
    </div>
  
 <div class="title-h1">
    <h1 class="title">
      <i class="fa-solid fa-user-pen"></i>
      <?= e($view === 'register' ? $L['register_title'] : $L['login_title']) ?>
    </h1>
</div>
</div>
    <?php if (!empty($flashes)): ?>
      <?php foreach ($flashes as $type => $msg): ?>
        <div class="alert <?= e($type) ?> pop"><?= e($msg) ?></div>
      <?php endforeach; ?>
    <?php endif; ?>

    <div class="tabs">
      <a class="tab <?= $view==='register'?'active':'' ?>" href="?view=register&lang=<?= e(get_lang()) ?>">
        <i class="fa-solid fa-user-plus"></i> <?= e($L['toggle_to_register']) ?>
      </a>
      <a class="tab <?= $view==='login'?'active':'' ?>" href="?view=login&lang=<?= e(get_lang()) ?>">
        <i class="fa-solid fa-right-to-bracket"></i> <?= e($L['toggle_to_login']) ?>
      </a>
    </div>

    <?php if ($view === 'register'): ?>
      <form class="form slide-up" action="process_register.php" method="post" novalidate>
        <div class="field">
          <i class="fa-solid fa-signature"></i>
          <input type="text" name="fullname_fa" placeholder=" " required>
          <label><?= e($L['fullname_fa']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-language"></i>
          <input type="text" name="fullname_en" placeholder=" "required>
          <label><?= e($L['fullname_en']) ?></label>
        </div>
       <div class="field">
  <i class="fa-solid fa-user"></i>
  <input type="text" name="username" placeholder=" " required>
  <label><?= e($L['username']) ?></label>
</div>
        <div class="field">
          <i class="fa-solid fa-lock"></i>
          <input type="password" name="password" placeholder=" " minlength="6" required>
          <label><?= e($L['password']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-lock"></i>
          <input type="password" name="password_confirm" placeholder=" " minlength="6" required>
          <label><?= e($L['password_confirm']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-mobile-screen"></i>
          <input type="tel" name="mobile" placeholder=" " pattern="[0-9+\- ]{8,15}" required>
          <label><?= e($L['mobile']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-envelope"></i>
          <input type="email" name="email" placeholder=" " required>
          <label><?= e($L['email']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-key"></i>
          <input type="text" name="verify" placeholder=" " inputmode="numeric" pattern="[0-9]{4}" required>
          <label><?= e($L['verify_code']) ?> <small>(<?= e($L['verify_hint']) ?>)</small></label>
        </div>

        <button class="btn pulse" type="submit">
          <i class="fa-solid fa-circle-check"></i> <?= e($L['register_btn']) ?>
        </button>

        <p class="note"><?= e($L['labels_note']) ?></p>
      </form>
    <?php else: ?>
      <form class="form slide-up" action="process_login.php" method="post" novalidate>
        <div class="field">
          <i class="fa-solid fa-user"></i>
          <input type="text" name="username" placeholder=" " required>
          <label><?= e($L['username']) ?></label>
        </div>
        <div class="field">
          <i class="fa-solid fa-lock"></i>
          <input type="password" name="password" placeholder=" " required>
          <label><?= e($L['password']) ?></label>
        </div>
        <button class="btn pulse" type="submit">
          <i class="fa-solid fa-right-to-bracket"></i> <?= e($L['login_btn']) ?>
        </button>
      </form>
    <?php endif; ?>
  </div>

<script src="assets/js/app.js"></script>
</body>
</html>



<script src="assets/js/app.js"></script>
</body>
</html>
