<?php
require __DIR__ . '/config.php';
require __DIR__ . '/functions.php';
$L = load_lang();

// 1) دریافت ورودی‌ها
$fullname_fa = trim($_POST['fullname_fa'] ?? '');
$fullname_en = trim($_POST['fullname_en'] ?? '');
$username    = trim($_POST['username'] ?? '');
$password    = $_POST['password'] ?? '';
$confirm     = $_POST['password_confirm'] ?? '';
$mobile      = trim($_POST['mobile'] ?? '');
$email       = trim($_POST['email'] ?? '');
$verify      = trim($_POST['verify'] ?? '');

// 2) اعتبارسنجی ساده در سمت سرور
if ($verify !== '1365') {
    flash('error', $L['wrong_verify']);
    header("Location: index.php?view=register&lang=" . get_lang());
    exit;
}

if ($password !== $confirm) {
    flash('error', $L['pass_mismatch']);
    header("Location: index.php?view=register&lang=" . get_lang());
    exit;
}

try {
    // بررسی یکتا بودن نام کاربری
    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
    $stmt->execute([$username]);
    if ($stmt->fetch()) {
        flash('error', $L['user_exists']);
        header("Location: index.php?view=register&lang=" . get_lang());
        exit;
    }

    // ذخیره کاربر
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users 
        (fullname_fa, fullname_en, username, password_hash, mobile, email, created_at) 
        VALUES (?, ?, ?, ?, ?, ?, NOW())");
    $ok = $stmt->execute([$fullname_fa, $fullname_en, $username, $hash, $mobile, $email]);

    if ($ok) {
        flash('success', $L['user_created']);
        header("Location: index.php?view=login&lang=" . get_lang());
        exit;
    } else {
        flash('error', $L['db_error']);
        header("Location: index.php?view=register&lang=" . get_lang());
        exit;
    }
} catch (Throwable $e) {
    flash('error', $L['db_error']);
    header("Location: index.php?view=register&lang=" . get_lang());
    exit;
}
