<?php
require __DIR__ . '/config.php';
require __DIR__ . '/functions.php';
$L = load_lang();

$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';

try {
    $stmt = $pdo->prepare("SELECT id, username, fullname_fa, fullname_en, password_hash FROM users WHERE username = ? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['fullname_fa'] = $user['fullname_fa'];
        $_SESSION['fullname_en'] = $user['fullname_en'];
        header("Location: dashboard.php");
        exit;
    } else {
        flash('error', $L['bad_login']);
        header("Location: index.php?view=login&lang=" . get_lang());
        exit;
    }
} catch (Throwable $e) {
    flash('error', $L['bad_login']);
    header("Location: index.php?view=login&lang=" . get_lang());
    exit;
}
