<?php
/**
 * توابع مشترک: بارگذاری زبان، ترجمه، امنیت و کمکی‌ها
 */

// زبان پیش‌فرض: fa
function get_lang(): string
{
    // اولویت: پارامتر URL ← نشست ← مرورگر
    if (!empty($_GET['lang']) && in_array($_GET['lang'], ['fa','en'])) {
        $_SESSION['lang'] = $_GET['lang'];
    }
    if (!empty($_SESSION['lang'])) {
        return $_SESSION['lang'];
    }
    // تشخیص ساده از هدر مرورگر
    $accept = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
    return (stripos($accept, 'fa') !== false) ? 'fa' : 'en';
}

function load_lang(): array
{
    $lang = get_lang();
    $path = __DIR__ . "/lang/{$lang}.php";
    if (!is_file($path)) $path = __DIR__ . "/lang/fa.php";
    /** @var array $L */
    $L = require $path;
    return $L;
}

// ترجمه
function t(string $key, array $repl = []): string
{
    static $cache = null;
    if ($cache === null) $cache = load_lang();
    $text = $cache[$key] ?? $key;
    foreach ($repl as $k => $v) {
        $text = str_replace('{' . $k . '}', $v, $text);
    }
    return $text;
}

// پاکسازی ورودی‌ها برای نمایش (برای DB از bindParam استفاده می‌کنیم)
function e(string $str): string
{
    return htmlspecialchars($str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

// بررسی ورود
function require_auth(): void
{
    if (empty($_SESSION['user_id'])) {
        header("Location: index.php?view=login");
        exit;
    }
}

// جهت راست‌به‌چپ
function dir_attr(): string
{
    return get_lang() === 'fa' ? 'rtl' : 'ltr';
}

function align_class(): string
{
    return get_lang() === 'fa' ? 'rtl' : 'ltr';
}

// نمایش پیام فلش
function flash(?string $key = null, ?string $val = null)
{
    if ($key !== null && $val !== null) {
        $_SESSION['flash'][$key] = $val;
        return;
    }
    $msg = $_SESSION['flash'] ?? [];
    unset($_SESSION['flash']);
    return $msg;
}
