<?php
require __DIR__ . '/config.php';
require __DIR__ . '/functions.php';
require_auth();
$L = load_lang();
$name = get_lang() === 'fa' ? ($_SESSION['fullname_fa'] ?? $_SESSION['username']) : ($_SESSION['fullname_en'] ?? $_SESSION['username']);
?>
<!doctype html>
<html lang="<?= get_lang() ?>" dir="<?= dir_attr() ?>">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= e($L['dashboard']) ?></title>
<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.fontcdn.ir/Font/Persian/IRANSansX/IRANSansX.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="assets/css/app.css">
</head>
<body class="<?= align_class() ?>">
  <div class="bg-animated"></div>
  <div class="container glass fade-in">
    <h1 class="title"><i class="fa-solid fa-house-user"></i> <?= e($L['dashboard']) ?></h1>
    <p class="welcome"><i class="fa-solid fa-face-smile"></i> <?= e(t('welcome', ['name'=>$name])) ?></p>
    <a class="btn" href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> <?= e($L['logout_btn']) ?></a>
  </div>
</body>
</html>
